/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

// ISecDialog.cpp : implementation file
//

#include "stdafx.h"
#include "CClient.h"
#include "ISecDialog.h"

#include "funcheader.h"
#include "section.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CISecDialog dialog


CISecDialog::CISecDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CISecDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CISecDialog)
	m_iVerticalThickness = 0.0;
	m_iHorizontalThickness = 0.0;
	m_iLength = 0.0;
	m_iWidth = 0.0;
	m_iExtHeight = 0.0;
	m_blendRadius = 0.0;
	m_check1 = FALSE;
	//}}AFX_DATA_INIT
}


void CISecDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CISecDialog)
	DDX_Text(pDX, IDC_IEDIT1, m_iVerticalThickness);
	DDX_Text(pDX, IDC_IEDIT2, m_iHorizontalThickness);
	DDX_Text(pDX, IDC_IEDIT3, m_iLength);
	DDX_Text(pDX, IDC_IEDIT4, m_iWidth);
	DDX_Text(pDX, IDC_IEDIT5, m_iExtHeight);
	DDX_Text(pDX, IDC_IEDIT6, m_blendRadius);
//	DDV_MinMaxDouble(pDX, m_blendRadius, 1.e-004, 1000.);
	DDX_Check(pDX, IDC_CHECK1, m_check1);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CISecDialog, CDialog)
	//{{AFX_MSG_MAP(CISecDialog)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CISecDialog message handlers

void CISecDialog::OnOK() 
{
	HRESULT status = CONV_SUCCESS;

	ISet *objset1 = NULL;
	UpdateData(TRUE);
	if(!m_check1)
		m_blendRadius = 0.0;

	if(m_iLength >0 && m_iVerticalThickness > 0 && m_iHorizontalThickness > 0
		&& m_iWidth > 0 && m_iExtHeight > 0
		&& m_iVerticalThickness < m_iLength && m_iVerticalThickness < m_iWidth
		&& m_iHorizontalThickness < m_iLength && m_iHorizontalThickness < m_iWidth) {
		
		status = CreateISection(m_iLength/1000, m_iVerticalThickness/1000,
			m_iHorizontalThickness/1000, m_iWidth/1000, m_iExtHeight/1000, m_blendRadius/1000, &objset1);
		if(status || !objset1){
			AfxMessageBox("CreateISection failed");
		}
	}
	else
		AfxMessageBox("Invalid Input");

	CDialog::OnOK();
}
